package gov.va.med.mhv.usermgmt.bizobj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.PatientPK;

/**
 * Business object for the FacilityInfo application entity
 *
 * Generated Skeleton Code
 */
 
public class FacilityInfoBO extends FacilityInfoBaseBO {
	
	protected void complexValidation() {
	}
	
	/**
	 * Execute the queryByPatient query
	 *
	 * @param patient The <tt>Patient</tt> by which to query
	 * @return <tt>List</tt> of <tt>FacilityInfo</tt>s
	 */	 
	public static List<FacilityInfoBO> queryByPatient(Patient patient) {
		List<FacilityInfoBO> boList = null;
		if (patient != null) {
			PatientPK pk = patient.getPatientPK();
			PatientBO patientBO = PatientBO.findByPrimaryKey(pk);
			boList = queryByPatient(patientBO);
			
		} else {
			boList = Collections.EMPTY_LIST;
			
		}
		
		return boList;
	}
	
	/**
	 * Execute the queryByPatient query
	 *
	 * @param patientBO The <tt>PatientBO</tt> by which to query
	 * @return <tt>List</tt> of <tt>FacilityInfo</tt>s
	 */	 
	public static List<FacilityInfoBO> queryByPatient(PatientBO patientBO) {
		List<FacilityInfoBO> boList = Collections.EMPTY_LIST;;
		if (patientBO != null) {				
			FacilityBO facilityBO;
			FacilityInfoBO facilityInfoBO;
			Set facilities = patientBO.getFacilitys();
			if (facilities != null) {
				boList = new ArrayList<FacilityInfoBO>(facilities.size());
				Iterator facilitiesIterator = facilities.iterator();
				while (facilitiesIterator.hasNext()) {
					facilityBO =  (FacilityBO)facilitiesIterator.next();
					facilityInfoBO =  facilityBO.getFacilityInfo();					
					boList.add(facilityInfoBO);
				}
			}
			
		}
		
		return boList;
	}

}